// Copyright (c) Caliper Corporation 2003.  All Rights Reserved
// Written by Stewart Berry - Caliper Corporation - 2003

    // This toolbox demonstrates different error types and ways to handle errors
    
    // The toolbox illustrates how to:
    // 1. Handle errors produced by a function such as ClickCoord()
    // 2. Define special error handlers

    // To run this toolbox using the GISDK toolbox:
    // 1. Open or make current the map that you want to use.
    // 2. Choose Tools-Add-Ins and open the GIS Developer's Kit toolbox.
    // 3. Compile this toolbox in test mode using the first button (Compile).
    // 4. Run this toolbox by clicking the second button (Test), typing the dbox 
    //    name "Main", clicking the Dialog Box radio button, and clicking OK.
    /* 
    Notes on Error handling:

    Caliper Script provides four statements for customized error and exception handling, with these formats:
    on exception goto label
    on exception default
    on exception do
	    <statements go here>
	    goto label
	    end
    on exception do
	    <statements go here>
	    Return()
	    end

    The exception types are:
    Exception	 Code	Meaning
    Error	        0	An error not described by one of the other exception types has occurred
    NotFound	    1	The object of a Caliper Script statement or function is not found (e.g., a nonexistent layer or data field is referenced)
    Escape	        2	The end user presses the Escape key or clicks both mouse buttons during an input operation
    NonUnique	    3	Multiple identical values are encountered where a single value is expected
    Missing	        4	A missing value is encountered in a data field
    DivideByZero	5	A division by zero is encountered
    EndOfFile	    6	The end of an input file is encountered
    Locked	        7	A time-out is experienced because a required file is locked
    LanguageError	8	There is an error in a Caliper Script statement, such as the wrong types passed to a function or used with an operator
    */

DBox "Main"  ,, 10, 5 Toolbox NoKeyboard
    Title: "Test of Error"
    
    // Initialise
    Init do
        if getmaps() = null then do
            showmessage("You must open a map to run this tool.")
            return()
            end
    enditem
    
    // On close terminate the execution of the dialog box and close its window
    close do Return() endItem

    // Set the tool icons, cursor type, and Help information
    tool "Click" 3.25,.25 Icons:"bmp\\buttons|11", "bmp\\buttons|45", 
        "bmp\\buttons|79" Cursor: "Arrow" 
    help: "Click on a Map. While holding down the left mouse button on a map press ESC once to cause an error. Three error handling macros are run in a loop, one for each execution of the click tool."
    do 
        // Share this variable
        shared errorcount
        if errorcount = null then errorcount = 0
        errorcount = errorcount + 1
        // If the last macro run was the unhandled error macro (error handling3) then reset tool
        if errorcount = 4 then do
            showmessage("As an unhandled error occurred in macro(error handling3) the tool is reset.")
            errorcount = null
            SetTool()
            return()
            end
        // Each time the tool is run, run the next macro in the loop
        macro = "error handling"+i2s(errorcount)
        no_error = RunMacro(macro)
        if no_error <> null then errorcount = 0 
    enditem

    // On close terminate the execution of the dialog box and close its window
    button "Close" 1.5, after, 7, 1.5 cancel
        do Return() endItem

endDBox

// Demonstrates error handling using the ShowMessage() function
Macro "error handling1"

    // Two types of error can be returned by ClickCoord():
    // 1. The user clicked Cancel
    on Escape goto showmessage
    // 2. The input coordinate is invalid (e.g., off the world)
    on NotFound	do 
        return()
        end

    // ClickCoord() Awaits user input from the system pointer and returns a coordinate.
    // If this fails (by holding down the left mouse button and pressing ESC),
    // the appropriate error handler runs.
    user_coord = null
    setmap(getmap())
    user_coord = ClickCoord()

   showmessage:
    if user_coord = null then showmessage("There was an error, and the goto statment moved the position in the code to showmessage:")
    if user_coord <> null then showmessage("There was no error.")
    user_coord = null

    // Cancels the special error handling defined above
    on Escape default
    on NotFound default

    // Deselects the tool
    SetTool()

endmacro

///////////////////////////////////////////////////////////////////

// Demonstrates error handling by supressing the error and terminating execution
Macro "error handling2"

    // Two types of error can be returned by ClickCoord():
    // 1. The user clicked Cancel
    on Escape do
        // cancels the special error handling defined above
        on Escape default 
        showmessage("The error is supressed using return(), terminating execution.")
        SetTool()
        return()
        end
    // 2. The input coordinate is invalid (e.g., off the world)
    on NotFound	do 
        return()
        end

    // ClickCoord() Awaits user input from the system pointer and returns a coordinate.
    // If this fails (by holding down the left mouse button and pressing ESC once),
    // the appropriate error handler runs.
    user_coord = null
    setmap(getmap())
    user_coord = ClickCoord()
    if user_coord <> null then showmessage("There was no error.")
    user_coord = null

    // Cancels the special error handling defined above
    on NotFound default
    on Escape default

    // Deselects the tool
    SetTool()

endmacro

///////////////////////////////////////////////////////////////////

// Demonstrates an unhandled error
Macro "error handling3"

    // Two types of error can be returned by ClickCoord():
    // 1. The user clicked Cancel
    // 2. The input coordinate is invalid (e.g., off the world)
    // In this example no special error handling is defined

    // ClickCoord() Awaits user input from the system pointer and returns a coordinate.
    // If this fails (by holding down the left mouse button and pressing ESC once),
    // the default error message appears as it is an unhandled error
    user_coord = null
    setmap(getmap())
    user_coord = ClickCoord()

    // The first showmessage() is never executed as the error is unhandled and so
    // user_coord can never be null at this point in the code
    if user_coord = null then showmessage("There was an error, and the default error message was displayed")
    if user_coord <> null then showmessage("There was no error.") 
    user_coord = null

    // Deselects the tool
    SetTool()

    // If no unhandled error occurred return this string
    return("no_error")

endmacro